﻿/*		VERSION:		1.0

USAGE:
	#include "functions/eventSystem3.as"
	react = make_react( unloadEmitter );		// param is optional
	
	react.to("unload").from(_this).then = react.unload;
	
	react.to("click").from(mc).then = function(evt){}
	
	var detectClick = react.to("click").from(_this);
	detectClick.then = function(evt){}
	detectClick.disable();
	
*/
function make_react( defaultUnloadEmitter )
{
	var react = {};		// interface
	var eventEmitters = [];
	
	
	//////////////////////////////////////////
	react.to = function( eventName ){
		var event = {};
		event.from = function( emitter ){
			var _interface = {};
			
			// catch actual event => eventTarget obj
			var eventTarget = {};		// the actual events fire at this
			if(emitter.addEventListener){
				emitter.addEventListener( eventName, eventTarget );
			}else if(emitter.addListener){
				emitter.addListener( eventTarget );
			}else{
				// cannot create event,  so return nothing
				var nam = (emitter._name === undefined) ? "[object]" : '"'+emitter._name+'"';
				trace('ERROR:  '+nam+' cannot send events. ('+eventName+')');
				return null;
			}
			
			// event occurs => then()
			eventTarget[eventName] = function(){
				_interface.then.apply( null, arguments.slice() );		// when this even occurs,  run then()  and pass-thru all provided parameters to it
			}// upon event()
			
			// remember this event
			var eventDetails = {
				emitter: emitter,
				eventName: eventName,
				eventTarget: eventTarget
			}
			eventEmitters.push(eventDetails);
			
			// manually destroy event
			_interface.disable = function(){
				disableEvent( emitter, eventName, eventTarget );
				forgetEvent( emitter, eventName, eventTarget );
			}// disable()
			
			// output:  {}.then
			return _interface;
		}// from()
		return event;
	}// to()
	
	
	function unload(){
		for(var nam in eventEmitters){
			var details = eventEmitters[nam];
			var emitter = details.emitter;
			var eventName = details.eventName;
			var eventTarget = details.eventTarget;
			disableEvent( emitter, eventName, eventTarget );
		}// for:  each known event
		eventEmitters = [];
	}// unload()
	react.unload = once( unload );
	
	
	//////////////////////////////////////////
	if(defaultUnloadEmitter){
		react.to("unload").from(defaultUnloadEmitter).then = react.unload;
	}// if:  defaultUnloadEmitter is specified
	
	
	return react;
	
	
	//////////////////////////////////////////
	function disableEvent( emitter, eventName, eventTarget )
	{
		if(emitter.removeEventListener){
			emitter.removeEventListener( eventName, eventTarget );
		}else{
			emitter.removeListener( eventTarget );
		}
	}// disableEvent()
	
	
	function forgetEvent( emitter, eventName, eventTarget )
	{
		for(var e in eventEmitters){
			var thisEvent = eventEmitters[e];
			if(thisEvent.emitter			!== emitter)				continue;		// no match,  so don't remove
			if(thisEvent.eventName		!== eventName)			continue;		// no match,  so don't remove
			if(thisEvent.eventTarget	!== eventTarget)		continue;		// no match,  so don't remove
			// remove
			eventEmitters.splice( e, 1 );
		}// for:  each known event
		delete thisEvent;
	}// forgetEvent()
	
	
	function once( func ){
		var done = false;
		return function () {
			return done ? void 0 : ((done = true), func.apply(this, arguments));
		}
	}// once()
	
}// make_react()